﻿#pragma once
#include <vector>
struct _SecHandle;

class WinCryptSock
{
public:
  WinCryptSock(int Socket, const char* ServerName);
  ~WinCryptSock();
  bool CreateCredentials();
  bool Handshake();
  int Encrypt(std::vector<char>& out, const char * inBuf, int bufLen);
  int Decrypt(std::vector<char>& out, const char * inBuf, int bufLen);
  bool hasError() const { return !!Error_; };
  const char* getError() const { return Error_; };
private:
  int HandshakeLoop();
  int Socket_;
  const char* ServerName_;
  void* secureLib_;
  void* pSSPI_;
  void* hCreds_;
  void* hCreds_2;   // high half
  void* hContext_;
  void* hContext_2; // high half
  char* pbIoBufferOut;
  std::vector<char> decoderBuffer;
  int BufferSize;
  int BeginSize;
  int EndSize;
  bool PrepareBuffers();
  const char* Error_;
  void SetError(const char* Error);
  void* hMyCertStore_;
};
