﻿#pragma once
#include "liveMedia.hh"
#include <list>
#include "Version.h"

#define APPLICATION_NAME "ONVIF RTSP Client " DTT_VERSION
class EncryptedSocket;
class CLive555Wrapper;
class CWrapRTSPClient : public RTSPClient {
public:
  static CWrapRTSPClient* createNew(CLive555Wrapper *pWrapper)
  {
    return new CWrapRTSPClient(pWrapper);
  };

protected:
  CWrapRTSPClient(CLive555Wrapper *pWrapper);
  // called only by createNew();
  virtual ~CWrapRTSPClient();

  virtual void ReflectSend(const char* Data);
  virtual void ReflectReceive(const char* Data);
  virtual bool ReflectSocketHandshake(int Socket);

public:
  CLive555Wrapper * pWrapper;
  void Reset();
  Authenticator& Authenticator();
private:
  void WriteLog(const char* Text, ...);

  bool WebsocketHandshake(int Socket);
  bool HttpsHandshake(int Socket);
  std::list<EncryptedSocket*> _sockets;
};

