/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.sql.registry.SQLDialectDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLDialectRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLInsertReplaceMethodDescriptor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseConsumerPageLoadSettings
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(DatabaseConsumerPageLoadSettings.class);
    private final String HELP_TOPIC_REPLACE_METHOD = "Data-Import-and-Replace";
    private Button transferAutoGeneratedColumns;
    private Button truncateTargetTable;
    private Button disableReferentialIntegrity;
    private Combo onDuplicateKeyInsertMethods;
    private Group loadSettings;
    private String disableReferentialIntegrityCheckboxTooltip;
    private boolean isDisablingReferentialIntegritySupported;

    public DatabaseConsumerPageLoadSettings() {
        super(DTUIMessages.database_consumer_wizard_name);
        this.setTitle(DTUIMessages.database_consumer_wizard_title);
        this.setDescription(DTUIMessages.database_consumer_wizard_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        final DatabaseConsumerSettings settings = this.getSettings();
        this.loadSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_name, (int)2, (int)768, (int)0);
        this.transferAutoGeneratedColumns = UIUtils.createCheckbox((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_label, (String)DTUIMessages.database_consumer_wizard_transfer_checkbox_tooltip, (boolean)settings.isTransferAutoGeneratedColumns(), (int)2);
        this.transferAutoGeneratedColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setTransferAutoGeneratedColumns(DatabaseConsumerPageLoadSettings.this.transferAutoGeneratedColumns.getSelection());
            }
        });
        this.truncateTargetTable = UIUtils.createCheckbox((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_label, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_description, (boolean)settings.isTruncateBeforeLoad(), (int)2);
        this.truncateTargetTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection() && !DatabaseConsumerPageLoadSettings.this.confirmDataTruncate()) {
                    DatabaseConsumerPageLoadSettings.this.truncateTargetTable.setSelection(false);
                    return;
                }
                settings.setTruncateBeforeLoad(DatabaseConsumerPageLoadSettings.this.truncateTargetTable.getSelection());
            }
        });
        this.loadUISettingsForDisableReferentialIntegrityCheckbox();
        settings.setDisableReferentialIntegrity(this.isDisablingReferentialIntegritySupported && settings.isDisableReferentialIntegrity());
        this.disableReferentialIntegrity = UIUtils.createCheckbox((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_disable_referential_integrity_label, (String)this.disableReferentialIntegrityCheckboxTooltip, (boolean)settings.isDisableReferentialIntegrity(), (int)2);
        this.disableReferentialIntegrity.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setDisableReferentialIntegrity(DatabaseConsumerPageLoadSettings.this.disableReferentialIntegrity.getSelection());
            }
        });
        this.disableReferentialIntegrity.setEnabled(this.isDisablingReferentialIntegritySupported);
        UIUtils.createControlLabel((Composite)this.loadSettings, (String)DTUIMessages.database_consumer_wizard_on_duplicate_key_insert_method_text);
        this.onDuplicateKeyInsertMethods = new Combo((Composite)this.loadSettings, 12);
        this.onDuplicateKeyInsertMethods.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Link urlLabel = UIUtils.createLink((Composite)this.loadSettings, (String)("<a href=\"" + HelpUtils.getHelpExternalReference((String)"Data-Import-and-Replace") + "\">" + DTUIMessages.database_consumer_wizard_link_label_replace_method_wiki + "</a>"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Data-Import-and-Replace"));
            }
        });
        urlLabel.setLayoutData((Object)new GridData(4, 2, false, false, 2, 1));
        Group performanceSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_performance_group_label, (int)4, (int)768, (int)0);
        final Button newConnectionCheckbox = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTMessages.data_transfer_wizard_output_checkbox_new_connection, null, (boolean)settings.isOpenNewConnections(), (int)4);
        newConnectionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenNewConnections(newConnectionCheckbox.getSelection());
            }
        });
        final Button useTransactionsCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_transactions_checkbox_label, null, (boolean)settings.isUseTransactions(), (int)4);
        useTransactionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setUseTransactions(useTransactionsCheck.getSelection());
            }
        });
        final Spinner commitAfterEdit = UIUtils.createLabelSpinner((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_commit_spinner_label, (int)settings.getCommitAfterRows(), (int)1, (int)Integer.MAX_VALUE);
        commitAfterEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setCommitAfterRows(commitAfterEdit.getSelection());
            }
        });
        commitAfterEdit.setLayoutData((Object)new GridData(32, 2, false, false, 3, 1));
        final Button useBatchCheck = UIUtils.createCheckbox((Composite)performanceSettings, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_label, (String)DTUIMessages.database_consumer_wizard_disable_import_batches_description, (boolean)settings.isDisableUsingBatches(), (int)4);
        useBatchCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setDisableUsingBatches(useBatchCheck.getSelection());
            }
        });
        Group generalSettings = UIUtils.createControlGroup((Composite)composite, (String)DTUIMessages.database_consumer_wizard_general_group_label, (int)4, (int)768, (int)0);
        final Button showTableCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_table_checkbox_label, null, (boolean)settings.isOpenTableOnFinish(), (int)4);
        showTableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                settings.setOpenTableOnFinish(showTableCheckbox.getSelection());
            }
        });
        final Button showFinalMessageCheckbox = UIUtils.createCheckbox((Composite)generalSettings, (String)DTUIMessages.database_consumer_wizard_final_message_checkbox_label, null, (boolean)((DataTransferWizard)this.getWizard()).getSettings().isShowFinalMessage(), (int)4);
        showFinalMessageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((DataTransferWizard)DatabaseConsumerPageLoadSettings.this.getWizard()).getSettings().setShowFinalMessage(showFinalMessageCheckbox.getSelection());
            }
        });
        this.setControl((Control)composite);
    }

    private void loadUISettingsForDisableReferentialIntegrityCheckbox() {
        this.isDisablingReferentialIntegritySupported = false;
        this.disableReferentialIntegrityCheckboxTooltip = "";
        try {
            ((DataTransferWizard)this.getWizard()).getRunnableContext().run(false, false, monitor -> {
                LinkedHashSet<String> statements = new LinkedHashSet<String>();
                for (DatabaseMappingContainer mappingContainer : this.getSettings().getDataMappings().values()) {
                    if (!(mappingContainer.getTarget() instanceof DBPReferentialIntegrityController)) continue;
                    DBPReferentialIntegrityController controller = (DBPReferentialIntegrityController)mappingContainer.getTarget();
                    try {
                        if (!controller.supportsChangingReferentialIntegrity(monitor)) continue;
                        this.isDisablingReferentialIntegritySupported = true;
                        statements.add(controller.getChangeReferentialIntegrityStatement(monitor, false));
                        statements.add(controller.getChangeReferentialIntegrityStatement(monitor, true));
                    }
                    catch (DBException e) {
                        log.debug((Object)"Unexpected error when calculating UI options for 'Disable referential integrity' checkbox", (Throwable)e);
                    }
                }
                if (!statements.isEmpty()) {
                    StringJoiner tooltip = new StringJoiner(System.lineSeparator(), String.valueOf(DTUIMessages.database_consumer_wizard_disable_referential_integrity_tip_start) + System.lineSeparator(), "");
                    statements.forEach(tooltip::add);
                    this.disableReferentialIntegrityCheckboxTooltip = tooltip.toString();
                }
            });
        }
        catch (InvocationTargetException e) {
            log.debug((Object)"Unexpected error", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    private DatabaseConsumerSettings getSettings() {
        return ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, DatabaseConsumerSettings.class);
    }

    public void activatePage() {
        this.updatePageCompletion();
        UIUtils.asyncExec(this::loadSettings);
    }

    private void loadSettings() {
        DatabaseConsumerSettings settings = this.getSettings();
        if (settings.isTruncateBeforeLoad() && !this.confirmDataTruncate()) {
            this.truncateTargetTable.setSelection(false);
            settings.setTruncateBeforeLoad(false);
        }
        this.loadInsertMethods();
    }

    private boolean confirmDataTruncate() {
        String tableNames;
        String checkbox_question;
        Shell shell = this.getContainer().getShell();
        return !shell.isVisible() && !this.getSettings().isTruncateBeforeLoad() || UIUtils.confirmAction((Shell)shell, (String)DTUIMessages.database_consumer_wizard_truncate_checkbox_title, (String)(checkbox_question = NLS.bind((String)DTUIMessages.database_consumer_wizard_truncate_checkbox_question, (Object)(tableNames = ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes().stream().map(pipe -> pipe.getConsumer() == null ? "" : pipe.getConsumer().getObjectName()).collect(Collectors.joining(","))))));
    }

    private void loadInsertMethods() {
        final DatabaseConsumerSettings settings = this.getSettings();
        DBPDataSource dataSource = settings.getContainerNode().getDataSource();
        List insertMethodsDescriptors = null;
        if (dataSource != null) {
            SQLDialectDescriptor dialectDescriptor = SQLDialectRegistry.getInstance().getDialect(dataSource.getSQLDialect().getDialectId());
            insertMethodsDescriptors = dialectDescriptor.getSupportedInsertReplaceMethodsDescriptors();
        }
        this.onDuplicateKeyInsertMethods.add("<None>");
        if (!CommonUtils.isEmpty(insertMethodsDescriptors)) {
            boolean emptyButton = true;
            for (SQLInsertReplaceMethodDescriptor insertMethod : insertMethodsDescriptors) {
                this.onDuplicateKeyInsertMethods.add(insertMethod.getLabel());
                if (!insertMethod.getId().equals(settings.getOnDuplicateKeyInsertMethodId())) continue;
                this.onDuplicateKeyInsertMethods.setText(insertMethod.getLabel());
                emptyButton = false;
            }
            if (emptyButton) {
                this.onDuplicateKeyInsertMethods.setText("<None>");
                if (!CommonUtils.isEmpty((String)settings.getOnDuplicateKeyInsertMethodId())) {
                    settings.setOnDuplicateKeyInsertMethodId(null);
                }
            }
        } else {
            this.onDuplicateKeyInsertMethods.setText("<None>");
            this.onDuplicateKeyInsertMethods.setEnabled(false);
            Label descLabel = new Label((Composite)this.loadSettings, 0);
            descLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
            descLabel.setText("Replace method not supported by target database");
            if (!CommonUtils.isEmpty((String)settings.getOnDuplicateKeyInsertMethodId())) {
                settings.setOnDuplicateKeyInsertMethodId(null);
            }
        }
        final List finalInsertMethodsDescriptors = insertMethodsDescriptors;
        this.onDuplicateKeyInsertMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selIndex = DatabaseConsumerPageLoadSettings.this.onDuplicateKeyInsertMethods.getSelectionIndex();
                if (selIndex > 0 && !CommonUtils.isEmpty((Collection)finalInsertMethodsDescriptors)) {
                    SQLInsertReplaceMethodDescriptor methodDescriptor = (SQLInsertReplaceMethodDescriptor)finalInsertMethodsDescriptors.get(selIndex - 1);
                    settings.setOnDuplicateKeyInsertMethodId(methodDescriptor.getId());
                } else {
                    settings.setOnDuplicateKeyInsertMethodId(DatabaseConsumerPageLoadSettings.this.onDuplicateKeyInsertMethods.getText());
                }
            }
        });
    }

    public void deactivatePage() {
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        return true;
    }
}

