/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.utils.CommonUtils;

public class GenericDataSourceInfo
extends JDBCDataSourceInfo {
    private final boolean supportsLimits;
    private boolean supportsMultipleResults;
    private boolean supportsNullableUniqueConstraints;
    private final boolean supportsSetArray;
    private final boolean supportsTransactionsForDDL;
    private final boolean supportsConstraints;

    public GenericDataSourceInfo(DBPDriver driver, JDBCDatabaseMetaData metaData) {
        super(metaData);
        this.supportsLimits = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-limits"), (boolean)true);
        this.setSupportsResultSetScroll(CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-scroll"), (boolean)false));
        this.supportsMultipleResults = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-multiple-results"), (boolean)false);
        this.supportsSetArray = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-set-array"), (boolean)false);
        this.supportsTransactionsForDDL = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-ddl-transactions"), (boolean)true);
        this.setReadOnly(CommonUtils.getBoolean((Object)driver.getDriverParameter("read-only-data"), (boolean)false));
        this.supportsNullableUniqueConstraints = false;
        this.supportsConstraints = CommonUtils.getBoolean((Object)driver.getDriverParameter("supports-table-constraints"), (boolean)true);
    }

    public boolean supportsResultSetLimit() {
        return this.supportsLimits;
    }

    public boolean supportsNullableUniqueConstraints() {
        return this.supportsNullableUniqueConstraints;
    }

    public void setSupportsNullableUniqueConstraints(boolean supportsNullableUniqueConstraints) {
        this.supportsNullableUniqueConstraints = supportsNullableUniqueConstraints;
    }

    public boolean supportsMultipleResults() {
        return this.supportsMultipleResults;
    }

    public boolean supportsSetArray() {
        return this.supportsSetArray;
    }

    public boolean supportsTransactionsForDDL() {
        return super.supportsTransactionsForDDL() && this.supportsTransactionsForDDL;
    }

    public boolean supportsTableConstraints() {
        return this.supportsConstraints;
    }
}

