/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.util.Iterator;
import java.util.Vector;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.IOUtils;

class SSHUtils {
    private static final Log log = Log.getLog(SSHUtils.class);

    SSHUtils() {
    }

    static int findFreePort(DBPPlatform platform) {
        DBPPreferenceStore store = platform.getPreferenceStore();
        int minPort = store.getInt("net.tunnel.port.min");
        int maxPort = store.getInt("net.tunnel.port.max");
        return IOUtils.findFreePort((int)minPort, (int)maxPort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isKeyEncrypted(String privKeyPath) {
        if (privKeyPath == null) return false;
        try {
            Identity identity;
            JSch testSch = new JSch();
            testSch.addIdentity(privKeyPath);
            IdentityRepository ir = testSch.getIdentityRepository();
            Vector identities = ir.getIdentities();
            Iterator iterator = identities.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(identity = (Identity)iterator.next()).isEncrypted());
            return true;
        }
        catch (JSchException e) {
            log.debug((Object)("Can't check private key encryption: " + e.getMessage()));
        }
        return false;
    }
}

