/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.edit.SQLServerObjectManager;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SQLServerProcedureManager
extends SQLServerObjectManager<SQLServerProcedure, SQLServerSchema> {
    @Nullable
    public DBSObjectCache<SQLServerSchema, SQLServerProcedure> getObjectsCache(SQLServerProcedure object) {
        return ((SQLServerSchema)object.getContainer()).getProcedureCache();
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)((SQLServerProcedure)command.getObject()).getName())) {
            throw new DBException("Procedure name cannot be empty");
        }
        if (!((SQLServerProcedure)command.getObject()).isPersisted() && CommonUtils.isEmpty((String)((SQLServerProcedure)command.getObject()).getBody())) {
            throw new DBException("Procedure body cannot be empty");
        }
    }

    protected SQLServerProcedure createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new SQLServerProcedure((SQLServerSchema)container);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        this.createOrReplaceProcedureQuery(monitor, executionContext, actions, (SQLServerProcedure)command.getObject(), true);
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        if (command.getProperties().size() > 1 || command.getProperty((Object)"description") == null) {
            this.createOrReplaceProcedureQuery(monitor, executionContext, actionList, (SQLServerProcedure)command.getObject(), false);
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        this.addDatabaseSwitchAction1(executionContext, actions, ((SQLServerSchema)((SQLServerProcedure)command.getObject()).getContainer()).getDatabase());
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop procedure", "DROP " + ((SQLServerProcedure)command.getObject()).getProcedureType() + " " + ((SQLServerProcedure)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
        this.addDatabaseSwitchAction2(executionContext, actions, ((SQLServerSchema)((SQLServerProcedure)command.getObject()).getContainer()).getDatabase());
    }

    private void createOrReplaceProcedureQuery(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLServerProcedure procedure, boolean create) throws DBException {
        this.addDatabaseSwitchAction1(executionContext, actions, ((SQLServerSchema)procedure.getContainer()).getDatabase());
        if (create) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create procedure", procedure.getBody()));
        } else {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter procedure", SQLServerUtils.changeCreateToAlterDDL(((SQLServerDataSource)procedure.getDataSource()).getSQLDialect(), procedure.getBody())));
        }
        this.addDatabaseSwitchAction2(executionContext, actions, ((SQLServerSchema)procedure.getContainer()).getDatabase());
    }

    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<SQLServerProcedure, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) throws DBException {
        SQLServerProcedure procedure = (SQLServerProcedure)command.getObject();
        if (command.getProperty((Object)"description") != null) {
            SQLServerDatabase database = ((SQLServerSchema)procedure.getContainer()).getDatabase();
            boolean isUpdate = SQLServerUtils.isCommentSet(monitor, database, SQLServerObjectClass.OBJECT_OR_COLUMN, procedure.getObjectId(), 0L);
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Add procedure comment", "EXEC " + SQLServerUtils.getSystemTableName(database, isUpdate ? "sp_updateextendedproperty" : "sp_addextendedproperty") + " 'MS_Description', " + SQLUtils.quoteString((DBSObject)procedure, (String)procedure.getDescription()) + "," + " 'schema', " + SQLUtils.quoteString((DBSObject)procedure, (String)((SQLServerSchema)procedure.getContainer()).getName()) + "," + " 'procedure', " + SQLUtils.quoteString((DBSObject)procedure, (String)procedure.getName())));
        }
    }
}

