/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import java.util.Vector;

public class RemoteIdentityRepository
implements IdentityRepository {
    private AgentProxy agent;

    public RemoteIdentityRepository(Connector connector) {
        this.agent = new AgentProxy(connector);
    }

    public Vector<Identity> getIdentities() {
        Vector<Identity> result = new Vector<Identity>();
        com.jcraft.jsch.agentproxy.Identity[] identities = this.agent.getIdentities();
        for (int i = 0; i < identities.length; ++i) {
            final com.jcraft.jsch.agentproxy.Identity _identity = identities[i];
            Identity id = new Identity(){
                byte[] blob;
                String algname;
                {
                    this.blob = _identity.getBlob();
                    this.algname = new String(new Buffer(this.blob).getString());
                }

                public boolean setPassphrase(byte[] passphrase) throws JSchException {
                    return true;
                }

                public byte[] getPublicKeyBlob() {
                    return this.blob;
                }

                public byte[] getSignature(byte[] data) {
                    return RemoteIdentityRepository.this.agent.sign(this.blob, data);
                }

                public boolean decrypt() {
                    return true;
                }

                public String getAlgName() {
                    return this.algname;
                }

                public String getName() {
                    return new String(_identity.getComment());
                }

                public boolean isEncrypted() {
                    return false;
                }

                public void clear() {
                }
            };
            result.addElement(id);
        }
        return result;
    }

    public boolean add(byte[] identity) {
        return this.agent.addIdentity(identity);
    }

    public boolean remove(byte[] blob) {
        return this.agent.removeIdentity(blob);
    }

    public void removeAll() {
        this.agent.removeAllIdentities();
    }

    public String getName() {
        return this.agent.getConnector().getName();
    }

    public int getStatus() {
        if (this.agent.getConnector().isAvailable()) {
            return 2;
        }
        return 1;
    }
}

