/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class DataSourceViewDescriptor
extends AbstractDescriptor {
    private String id;
    private String targetID;
    private List<String> dataSourceIds;
    private String label;
    private AbstractDescriptor.ObjectType viewType;
    private DBPImage icon;

    public DataSourceViewDescriptor(IConfigurationElement config) {
        super(config.getContributor().getName());
        this.id = config.getAttribute("id");
        this.targetID = config.getAttribute("targetID");
        this.dataSourceIds = Arrays.asList(config.getAttribute("dataSource").split(","));
        this.label = config.getAttribute("label");
        this.viewType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
    }

    public String getId() {
        return this.id;
    }

    public String getTargetID() {
        return this.targetID;
    }

    public List<String> getDataSources() {
        return this.dataSourceIds;
    }

    public String getLabel() {
        return this.label;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public <T> T createView(Class<T> implementsClass) {
        try {
            return (T)this.viewType.createInstance(implementsClass);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't create view '" + this.viewType.getImplName() + "'", ex);
        }
    }

    public String toString() {
        return this.id;
    }
}

