/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class Statements {
    private List<Statement> statements;

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Statement stmt : this.statements) {
            b.append(stmt.toString()).append(";\n");
        }
        return b.toString();
    }

    public Statements withStatements(List<Statement> statements) {
        this.setStatements(statements);
        return this;
    }

    public Statements addStatements(Statement ... statements) {
        List collection = Optional.ofNullable(this.getStatements()).orElseGet(ArrayList::new);
        Collections.addAll(collection, statements);
        return this.withStatements(collection);
    }

    public Statements addStatements(Collection<? extends Statement> statements) {
        List collection = Optional.ofNullable(this.getStatements()).orElseGet(ArrayList::new);
        collection.addAll(statements);
        return this.withStatements(collection);
    }
}

