/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Select;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryContainer;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingObject;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

public class DatabaseMappingContainer
implements DatabaseMappingObject {
    private static final Log log = Log.getLog(DatabaseMappingContainer.class);
    private final DatabaseConsumerSettings consumerSettings;
    private DBSDataContainer source;
    private DBSDataManipulator target;
    private String targetName;
    private DatabaseMappingType mappingType;
    private final List<DatabaseMappingAttribute> attributeMappings = new ArrayList<DatabaseMappingAttribute>();

    public DatabaseMappingContainer(DatabaseConsumerSettings consumerSettings, DBSDataContainer source) {
        this.consumerSettings = consumerSettings;
        this.source = source;
        this.mappingType = DatabaseMappingType.unspecified;
    }

    public DatabaseMappingContainer(DBRRunnableContext context, DatabaseConsumerSettings consumerSettings, DBSDataContainer sourceObject, DBSDataManipulator targetObject) throws DBException {
        this.consumerSettings = consumerSettings;
        this.source = sourceObject;
        this.target = targetObject;
        this.refreshMappingType(context, DatabaseMappingType.existing);
    }

    public DatabaseMappingContainer(DatabaseMappingContainer container, DBSDataContainer sourceObject) {
        this.consumerSettings = container.consumerSettings;
        this.source = sourceObject;
        this.target = container.target;
        this.targetName = container.targetName;
        this.mappingType = container.mappingType;
        for (DatabaseMappingAttribute attribute : container.attributeMappings) {
            this.attributeMappings.add(new DatabaseMappingAttribute(attribute, this));
        }
    }

    public DatabaseConsumerSettings getSettings() {
        return this.consumerSettings;
    }

    public DBSDataManipulator getTarget() {
        return this.target;
    }

    public void setTarget(DBSDataManipulator target) {
        this.target = target;
        this.targetName = null;
    }

    @Override
    public DatabaseMappingType getMappingType() {
        return this.mappingType;
    }

    public void refreshMappingType(DBRRunnableContext context, DatabaseMappingType mappingType) throws DBException {
        this.mappingType = mappingType;
        Collection<DatabaseMappingAttribute> mappings = this.getAttributeMappings(context);
        if (!CommonUtils.isEmpty(mappings)) {
            for (DatabaseMappingAttribute attr : mappings) {
                attr.updateMappingType((DBRProgressMonitor)new VoidProgressMonitor());
            }
        }
    }

    void setMappingType(DatabaseMappingType mappingType) {
        this.mappingType = mappingType;
    }

    public boolean isCompleted() {
        if (this.mappingType == DatabaseMappingType.skip) {
            return true;
        }
        for (DatabaseMappingAttribute attr : this.attributeMappings) {
            if (attr.getMappingType() != DatabaseMappingType.unspecified) continue;
            return false;
        }
        return true;
    }

    @Override
    public DBPImage getIcon() {
        return DBIcon.TREE_TABLE;
    }

    public DBSDataContainer getSource() {
        return this.source;
    }

    @Override
    public String getTargetName() {
        String targetTableName = this.targetName;
        if (CommonUtils.isEmpty((String)targetTableName)) {
            if (this.target != null) {
                targetTableName = this.target.getName();
            } else if (this.source != null) {
                Table table;
                SQLQuery sqlQuery;
                SQLQueryContainer sqlQueryContainer;
                DBSDataContainer adapterSource;
                if (this.source instanceof IAdaptable && (adapterSource = (DBSDataContainer)((IAdaptable)this.source).getAdapter(DBSDataContainer.class)) != null) {
                    this.source = adapterSource;
                }
                if (this.source instanceof SQLQueryContainer && (sqlQueryContainer = (SQLQueryContainer)this.source).getQuery() instanceof SQLQuery && (sqlQuery = (SQLQuery)sqlQueryContainer.getQuery()).getStatement() instanceof Select && (table = SQLSemanticProcessor.getTableFromSelect((Select)((Select)sqlQuery.getStatement()))) != null) {
                    targetTableName = table.getName();
                }
                if (CommonUtils.isEmpty((String)targetTableName)) {
                    targetTableName = this.source.getName();
                }
            } else {
                targetTableName = "";
            }
        }
        switch (this.mappingType) {
            case existing: {
                return this.target.getName();
            }
            case create: {
                return targetTableName;
            }
            case skip: {
                return "[skip]";
            }
        }
        return targetTableName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    DatabaseMappingAttribute getAttributeMapping(@NotNull DBPNamedObject sourceAttr) {
        return (DatabaseMappingAttribute)CommonUtils.findBestCaseAwareMatch(this.attributeMappings, (String)sourceAttr.getName(), attr -> attr.getSource().getName());
    }

    public Collection<DatabaseMappingAttribute> getAttributeMappings(DBRRunnableContext runnableContext) {
        if (this.attributeMappings.isEmpty()) {
            try {
                this.readAttributes((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(DTMessages.database_mapping_container_title_attributes_read_failed, NLS.bind((String)DTMessages.database_mapping_container_message_get_attributes_from, (Object)DBUtils.getObjectFullName((DBPNamedObject)this.source, (DBPEvaluationContext)DBPEvaluationContext.UI)), (Throwable)e);
            }
        }
        return this.attributeMappings;
    }

    public Collection<DatabaseMappingAttribute> getAttributeMappings(DBRProgressMonitor monitor) {
        if (this.attributeMappings.isEmpty()) {
            try {
                this.readAttributes(monitor);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(DTMessages.database_mapping_container_title_attributes_read_failed, NLS.bind((String)DTMessages.database_mapping_container_message_get_attributes_from, (Object)DBUtils.getObjectFullName((DBPNamedObject)this.source, (DBPEvaluationContext)DBPEvaluationContext.UI)), (Throwable)e);
            }
        }
        return this.attributeMappings;
    }

    private void readAttributes(DBRProgressMonitor monitor) throws DBException {
        for (DBSAttributeBase attr : DTUtils.getAttributes(monitor, this.source, this)) {
            this.addAttributeMapping(monitor, attr);
        }
    }

    private void addAttributeMapping(DBRProgressMonitor monitor, DBSAttributeBase attr) throws DBException {
        DatabaseMappingAttribute mapping = new DatabaseMappingAttribute(this, attr);
        mapping.updateMappingType(monitor);
        this.attributeMappings.add(mapping);
    }

    public void saveSettings(Map<String, Object> settings) {
        if (!CommonUtils.isEmpty((String)this.targetName)) {
            settings.put("targetName", this.targetName);
        } else if (this.target != null) {
            settings.put("targetName", this.target.getName());
        }
        if (this.mappingType != null) {
            settings.put("mappingType", this.mappingType.name());
        }
        if (!this.attributeMappings.isEmpty()) {
            LinkedHashMap<String, LinkedHashMap<String, Object>> attrsSection = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            settings.put("attributes", attrsSection);
            for (DatabaseMappingAttribute attrMapping : this.attributeMappings) {
                DBSAttributeBase sourceAttr = attrMapping.getSource();
                if (sourceAttr == null) continue;
                LinkedHashMap<String, Object> attrSettings = new LinkedHashMap<String, Object>();
                attrsSection.put(sourceAttr.getName(), attrSettings);
                attrMapping.saveSettings(attrSettings);
            }
        }
    }

    public void loadSettings(DBRRunnableContext context, Map<String, Object> settings) {
        Map attrsSection;
        this.targetName = CommonUtils.toString((Object)settings.get("targetName"), (String)this.targetName);
        if (settings.get("mappingType") != null) {
            try {
                DBSObject child;
                DBSObjectContainer objectContainer;
                DatabaseMappingType newMappingType = DatabaseMappingType.valueOf((String)settings.get("mappingType"));
                if (!CommonUtils.isEmpty((String)this.targetName) && (objectContainer = this.consumerSettings.getContainer()) != null && (child = objectContainer.getChild((DBRProgressMonitor)new VoidProgressMonitor(), this.targetName)) instanceof DBSDataManipulator) {
                    this.target = (DBSDataManipulator)child;
                }
                if (this.target != null && newMappingType == DatabaseMappingType.create) {
                    newMappingType = DatabaseMappingType.existing;
                } else if (this.target == null && newMappingType == DatabaseMappingType.existing) {
                    newMappingType = DatabaseMappingType.create;
                }
                this.refreshMappingType(context, newMappingType);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        if (!this.attributeMappings.isEmpty() && (attrsSection = (Map)settings.get("attributes")) != null) {
            for (DatabaseMappingAttribute attrMapping : this.attributeMappings) {
                Map attrSettings;
                DBSAttributeBase sourceAttr = attrMapping.getSource();
                if (sourceAttr == null || (attrSettings = (Map)attrsSection.get(sourceAttr.getName())) == null) continue;
                attrMapping.loadSettings(attrSettings);
            }
        }
    }

    public boolean isSameMapping(DatabaseMappingContainer mapping) {
        if (!CommonUtils.equalObjects((Object)this.source, (Object)mapping.source) || this.attributeMappings.size() != mapping.attributeMappings.size()) {
            return false;
        }
        int i = 0;
        while (i < this.attributeMappings.size()) {
            if (!CommonUtils.equalObjects((Object)this.attributeMappings.get(i).getSource().getName(), (Object)mapping.attributeMappings.get(i).getSource().getName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getTargetFullName() {
        DBSObjectContainer container = this.consumerSettings.getContainer();
        if (container instanceof DBSSchema || container instanceof DBSCatalog) {
            return String.valueOf(DBUtils.getObjectFullName((DBPNamedObject)container, (DBPEvaluationContext)DBPEvaluationContext.DML)) + "." + this.targetName;
        }
        return this.targetName;
    }
}

