/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.config;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartSelector;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;

public class PostgreTriggerConfigurator
implements DBEObjectConfigurator<PostgreTrigger> {
    public PostgreTrigger configureObject(DBRProgressMonitor monitor, Object parent, final PostgreTrigger trigger) {
        return (PostgreTrigger)new UITask<PostgreTrigger>(){

            protected PostgreTrigger runTask() {
                TriggerEditPage editPage = new TriggerEditPage(trigger);
                if (!editPage.edit()) {
                    return null;
                }
                trigger.setName(editPage.getEntityName());
                trigger.setFunction(editPage.selectedFunction);
                return trigger;
            }
        }.execute();
    }

    public class TriggerEditPage
    extends EntityEditPage {
        PostgreTrigger trigger;
        CSmartSelector<PostgreProcedure> functionCombo;
        PostgreProcedure selectedFunction;

        TriggerEditPage(PostgreTrigger trigger) {
            super((DBPDataSource)trigger.getDataSource(), DBSEntityType.TRIGGER);
            this.trigger = trigger;
        }

        protected Control createPageContents(Composite parent) {
            Composite pageContents = (Composite)super.createPageContents(parent);
            UIUtils.createControlLabel((Composite)pageContents, (String)"Trigger function");
            this.functionCombo = new PostgreProcedureSelector(pageContents, parent);
            GridData gd = new GridData(768);
            gd.widthHint = UIUtils.getFontHeight(this.functionCombo) * 30;
            this.functionCombo.setLayoutData((Object)gd);
            return pageContents;
        }

        public boolean isPageComplete() {
            return super.isPageComplete() && this.selectedFunction != null;
        }

        private class PostgreProcedureSelector
        extends CSmartSelector<PostgreProcedure> {
            private final Composite parent;

            PostgreProcedureSelector(Composite pageContents, Composite parent) {
                super(pageContents, 2060, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_PROCEDURE);
                    }

                    public String getText(Object element) {
                        if (element == null) {
                            return "N/A";
                        }
                        return ((PostgreProcedure)element).getFullQualifiedSignature();
                    }
                });
                this.parent = parent;
            }

            protected void dropDown(boolean drop) {
                DBNModel navigatorModel;
                DBNDatabaseNode dsNode;
                if (drop && (dsNode = (navigatorModel = DBWorkbench.getPlatform().getNavigatorModel()).getNodeByObject((DBSObject)TriggerEditPage.this.trigger.getDatabase())) != null) {
                    DBNDatabaseNode curNode = TriggerEditPage.this.selectedFunction == null ? null : navigatorModel.getNodeByObject((DBSObject)TriggerEditPage.this.selectedFunction);
                    DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)this.parent.getShell(), "Select function for ", (DBNNode)dsNode, (DBNNode)curNode, new Class[]{DBSInstance.class, DBSObjectContainer.class, PostgreProcedure.class}, new Class[]{PostgreProcedure.class}, null);
                    if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof PostgreProcedure) {
                        TriggerEditPage.this.functionCombo.removeAll();
                        TriggerEditPage.this.selectedFunction = (PostgreProcedure)((DBNDatabaseNode)node).getObject();
                        TriggerEditPage.this.functionCombo.addItem((Object)TriggerEditPage.this.selectedFunction);
                        TriggerEditPage.this.functionCombo.select((Object)TriggerEditPage.this.selectedFunction);
                        TriggerEditPage.this.updatePageState();
                    }
                }
            }
        }
    }
}

