/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;

class EndIdleTransactionsJob
extends AbstractJob {
    private static final Log log = Log.getLog(EndIdleTransactionsJob.class);
    private static final Set<String> activeDataSources = new HashSet<String>();
    private static final Object CONFIRM_SYNC = new Object();
    private final DBPDataSource dataSource;
    private final Map<DBCExecutionContext, DBCTransactionManager> txnToEnd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInProcess(DBPDataSourceContainer ds) {
        Set<String> set = activeDataSources;
        synchronized (set) {
            return activeDataSources.contains(ds.getId());
        }
    }

    EndIdleTransactionsJob(DBPDataSource dataSource, Map<DBCExecutionContext, DBCTransactionManager> txnToEnd) {
        super("Connection ping (" + dataSource.getContainer().getName() + ")");
        this.setUser(false);
        this.setSystem(true);
        this.dataSource = dataSource;
        this.txnToEnd = txnToEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        String dsId;
        block31: {
            Set<String> set;
            IStatus iStatus;
            block32: {
                dsId = this.dataSource.getContainer().getId();
                Set<String> set2 = activeDataSources;
                synchronized (set2) {
                    if (activeDataSources.contains(dsId)) {
                        return Status.CANCEL_STATUS;
                    }
                    activeDataSources.add(dsId);
                }
                try {
                    UIServiceConnections serviceConnections = DBWorkbench.getService(UIServiceConnections.class);
                    if (serviceConnections == null) break block31;
                    Object object = CONFIRM_SYNC;
                    synchronized (object) {
                        if (!serviceConnections.confirmTransactionsClose(this.txnToEnd.keySet().toArray(new DBCExecutionContext[0]))) {
                            iStatus = Status.CANCEL_STATUS;
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 13, 30] lbl23 : MonitorExitStatement: MONITOREXIT : var4_4
                            set = activeDataSources;
                            break block32;
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    Set<String> set3 = activeDataSources;
                    synchronized (set3) {
                        activeDataSources.remove(dsId);
                        throw throwable;
                    }
                }
            }
            synchronized (set) {
                activeDataSources.remove(dsId);
                return iStatus;
            }
        }
        log.debug("End idle " + this.txnToEnd.size() + " transactions for " + dsId);
        for (Map.Entry<DBCExecutionContext, DBCTransactionManager> tee : this.txnToEnd.entrySet()) {
            Throwable throwable = null;
            Object var7_12 = null;
            try (DBCSession session = tee.getKey().openSession(monitor, DBCExecutionPurpose.UTIL, "End idle transaction");){
                try {
                    tee.getValue().rollback(session, null);
                }
                catch (DBCException e) {
                    log.error("Error ending idle transaction", e);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        DBeaverNotifications.showNotification(this.dataSource, "rollback", "Transactions have been rolled back after long idle period", DBPMessageType.ERROR);
        Set<String> set = activeDataSources;
        synchronized (set) {
            activeDataSources.remove(dsId);
            return Status.OK_STATUS;
        }
    }
}

